/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*   File:         kmeans.h   (an MPI version)                               */
/*   Description:  header file for a parallel k-means clustering program     */
/*                                                                           */
/*   Author:  Wei-keng Liao                                                  */
/*            EECS Department Northwestern University                        */
/*            email: wkliao@eecs.northwestern.edu                            */
/*                                                                           */
/*   Copyright (C) 2013, Northwestern University                             */
/*   See COPYRIGHT notice in top-level directory.                            */
/*                                                                           */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef _H_KMEANS
#define _H_KMEANS

#include <assert.h>

#ifndef DATATYPE
#define DATATYPE float
#endif

extern int _debug;

int pnetcdf_read(char*, char*, long long*, long long*, int*, DATATYPE***, MPI_Comm);
int pnetcdf_read_centers(char*, char*, long long, int, float***, MPI_Comm);
int pnetcdf_write(char*, long long, long long, int, float**, long long*, long long, MPI_Comm, int);
int mpi_kmeans(DATATYPE**, int, long long, long long, float, long long*, float**, MPI_Comm);

#endif
